/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.minigun;

import java.util.List;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class ExplosiveGunAmmoItem
extends AbstractGunAmmoItem {
    @Override
    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().minigun.explosiveAmmoCartridgeSize.get();
    }

    @Override
    public int getAmmoColor(ItemStack ammo) {
        return 0xFF0000;
    }

    @Override
    public float getDamageMultiplier(Entity target, ItemStack ammoStack) {
        return ((Double)ConfigHelper.common().minigun.explosiveAmmoDamageMultiplier.get()).floatValue();
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        if (minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.explosiveAmmoExplosionChance.get())) {
            Level.ExplosionInteraction mode = (Boolean)ConfigHelper.common().minigun.explosiveAmmoTerrainDamage.get() != false ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            minigun.getWorld().explode(null, target.getX(), target.getY(), target.getZ(), ((Double)ConfigHelper.common().minigun.explosiveAmmoExplosionPower.get()).floatValue(), mode);
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockHitResult brtr) {
        if (minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.explosiveAmmoExplosionChance.get())) {
            Level.ExplosionInteraction mode = (Boolean)ConfigHelper.common().minigun.explosiveAmmoTerrainDamage.get() != false ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
            minigun.getWorld().explode(null, brtr.getLocation().x, brtr.getLocation().y, brtr.getLocation().z, ((Double)ConfigHelper.common().minigun.explosiveAmmoExplosionPower.get()).floatValue(), mode);
        }
        return super.onBlockHit(minigun, ammo, brtr);
    }

    @Override
    public void appendHoverText(ItemStack stack, Level world, List<Component> infoList, TooltipFlag extraInfo) {
        super.appendHoverText(stack, world, infoList, extraInfo);
        if (((Boolean)ConfigHelper.common().minigun.explosiveAmmoTerrainDamage.get()).booleanValue()) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainWarning", new Object[0]));
        } else {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.terrainSafe", new Object[0]));
        }
    }
}

