/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.minigun;

import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class FreezingGunAmmoItem
extends AbstractGunAmmoItem {
    @Override
    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().minigun.freezingAmmoCartridgeSize.get();
    }

    @Override
    public int getAmmoColor(ItemStack ammo) {
        return 4235519;
    }

    @Override
    protected float getDamageMultiplier(Entity target, ItemStack ammoStack) {
        double mul = super.getDamageMultiplier(target, ammoStack);
        if (target != null && target.fireImmune()) {
            mul *= 1.5;
        }
        return (float)mul;
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            living.setIsInPowderSnow(true);
            living.setTicksFrozen(living.getTicksFrozen() + 35);
            if (minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.freezingAmmoEntityIceChance.get())) {
                this.createFreezeCloud(minigun, target);
            }
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    private void createFreezeCloud(Minigun minigun, Entity target) {
        Level world = target.getCommandSenderWorld();
        AreaEffectCloud cloud = new AreaEffectCloud(world, target.getX(), target.getY(), target.getZ());
        cloud.setPotion(Potions.SLOWNESS);
        cloud.setOwner((LivingEntity)minigun.getPlayer());
        cloud.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 3));
        cloud.addEffect(new MobEffectInstance(MobEffects.WITHER, 20, 1));
        cloud.setRadius(2.0f);
        cloud.setDuration(60);
        cloud.setRadiusOnUse(-0.5f);
        cloud.setWaitTime(20);
        cloud.setFixedColor(-16727809);
        cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
        world.addFreshEntity((Entity)cloud);
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockHitResult brtr) {
        Level world = minigun.getWorld();
        BlockPos pos = brtr.getBlockPos();
        if (!world.dimensionType().ultraWarm() && minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.freezingAmmoBlockIceChance.get())) {
            Vec3 eye;
            ClipContext ctx;
            BlockHitResult res;
            BlockPos pos1 = world.getBlockState(pos).getShape((BlockGetter)world, pos) == Shapes.block() || brtr.getDirection() != Direction.UP ? pos.relative(brtr.getDirection()) : pos;
            BlockState newState = null;
            if (world.isEmptyBlock(pos1) && !world.isEmptyBlock(pos1.below())) {
                newState = (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(1));
            } else if (world.getBlockState(pos1).getBlock() == Blocks.SNOW) {
                BlockState state = world.getBlockState(pos1);
                int level = (Integer)state.getValue((Property)SnowLayerBlock.LAYERS);
                newState = level < 8 ? (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(level + 1)) : Blocks.SNOW_BLOCK.defaultBlockState();
            } else if (world.getBlockState(pos1).getBlock() == Blocks.WATER && (res = world.clip(ctx = new ClipContext(eye = minigun.getPlayer().getEyePosition(0.0f), brtr.getLocation(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)minigun.getPlayer()))).getType() == HitResult.Type.BLOCK) {
                pos1 = res.getBlockPos();
                newState = Blocks.ICE.defaultBlockState();
            }
            if (newState != null) {
                PneumaticCraftUtils.tryPlaceBlock(world, pos1, minigun.getPlayer(), brtr.getDirection(), newState);
            }
        }
        return super.onBlockHit(minigun, ammo, brtr);
    }
}

