/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.minigun;

import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;

public class IncendiaryGunAmmoItem
extends AbstractGunAmmoItem {
    @Override
    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().minigun.incendiaryAmmoCartridgeSize.get();
    }

    @Override
    public int getAmmoColor(ItemStack ammo) {
        return 0xFF8000;
    }

    @Override
    protected DamageSource getDamageSource(Minigun minigun) {
        return minigun.getPlayer().damageSources().onFire();
    }

    @Override
    protected float getDamageMultiplier(Entity target, ItemStack ammoStack) {
        float mul = super.getDamageMultiplier(target, ammoStack);
        return target != null && target.fireImmune() ? mul * 0.1f : mul;
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        if (minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.incendiaryAmmoEntityIgniteChance.get())) {
            target.setSecondsOnFire(((Integer)ConfigHelper.common().minigun.incendiaryAmmoFireDuration.get()).intValue());
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockHitResult brtr) {
        if (minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.incendiaryAmmoBlockIgniteChance.get())) {
            BlockPos firePos = brtr.getBlockPos().relative(brtr.getDirection());
            if (minigun.getWorld().getBlockState(firePos).isAir()) {
                PneumaticCraftUtils.tryPlaceBlock(minigun.getWorld(), firePos, minigun.getPlayer(), brtr.getDirection(), Blocks.FIRE.defaultBlockState());
            }
        }
        return super.onBlockHit(minigun, ammo, brtr);
    }
}

