/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.item.minigun;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.item.minigun.AbstractGunAmmoItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class StandardGunAmmoItem
extends AbstractGunAmmoItem {
    private static final String NBT_POTION = "potion";

    @Override
    public int getMaxDamage(ItemStack stack) {
        return (Integer)ConfigHelper.common().minigun.standardAmmoCartridgeSize.get();
    }

    @Nonnull
    public static ItemStack getPotion(ItemStack ammo) {
        if (ammo.getTag() != null && ammo.getTag().contains(NBT_POTION)) {
            return ItemStack.of((CompoundTag)ammo.getTag().getCompound(NBT_POTION));
        }
        return ItemStack.EMPTY;
    }

    public static void setPotion(ItemStack ammo, ItemStack potion) {
        NBTUtils.setCompoundTag(ammo, NBT_POTION, (Tag)Util.make((Object)new CompoundTag(), arg_0 -> ((ItemStack)potion).save(arg_0)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack stack) {
        return stack.isEnchanted() || stack.hasTag() && stack.getTag().contains(NBT_POTION);
    }

    @Override
    public int getAmmoCost(ItemStack ammoStack) {
        ItemStack potion = StandardGunAmmoItem.getPotion(ammoStack);
        return potion.isEmpty() ? 1 : StandardGunAmmoItem.getPotionAmmoCost(potion.getItem());
    }

    @Override
    public int getAmmoColor(ItemStack ammo) {
        return 0xFFFF00;
    }

    @Override
    public float getAirUsageMultiplier(Minigun minigun, ItemStack ammoStack) {
        if (minigun.getUpgrades(ModUpgrades.DISPENSER.get()) > 0 && !StandardGunAmmoItem.getPotion(ammoStack).isEmpty()) {
            return (float)minigun.getUpgrades(ModUpgrades.DISPENSER.get()) + 1.0f;
        }
        return 1.0f;
    }

    @Override
    public void appendHoverText(ItemStack stack, Level world, List<Component> infoList, TooltipFlag extraInfo) {
        super.appendHoverText(stack, world, infoList, extraInfo);
        ItemStack potion = StandardGunAmmoItem.getPotion(stack);
        if (!potion.isEmpty()) {
            ArrayList potionInfo = new ArrayList();
            potion.getItem().appendHoverText(potion, world, potionInfo, extraInfo);
            Object extra = "";
            if (potion.getItem() instanceof SplashPotionItem) {
                extra = " " + I18n.get((String)"pneumaticcraft.gui.tooltip.gunAmmo.splash", (Object[])new Object[0]);
            } else if (potion.getItem() instanceof LingeringPotionItem) {
                extra = " " + I18n.get((String)"pneumaticcraft.gui.tooltip.gunAmmo.lingering", (Object[])new Object[0]);
            }
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo", new Object[0]).append(" ").append((Component)potionInfo.get(0)).append((String)extra));
        } else {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.gunAmmo.combineWithPotion", new Object[0]));
        }
    }

    @Override
    public int onTargetHit(Minigun minigun, ItemStack ammo, Entity target) {
        ItemStack potion = StandardGunAmmoItem.getPotion(ammo);
        if (!potion.isEmpty() && target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            Player shooter = minigun.getPlayer();
            if (minigun.dispenserWeightedPercentage((Integer)ConfigHelper.common().minigun.potionProcChance.get(), 0.25f)) {
                if (potion.getItem() == Items.POTION) {
                    List effects = PotionUtils.getMobEffects((ItemStack)potion);
                    for (MobEffectInstance effect : effects) {
                        entity.addEffect(new MobEffectInstance(effect));
                    }
                    entity.level().playSound(null, entity.blockPosition(), SoundEvents.SPLASH_POTION_BREAK, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else if (potion.getItem() == Items.SPLASH_POTION || potion.getItem() == Items.LINGERING_POTION) {
                    ThrownPotion entityPotion = new ThrownPotion(shooter.level(), (LivingEntity)shooter);
                    entityPotion.setItem(potion);
                    entityPotion.setPos(entity.getX(), entity.getY(), entity.getZ());
                    shooter.level().addFreshEntity((Entity)entityPotion);
                }
            }
            return StandardGunAmmoItem.getPotionAmmoCost(potion.getItem());
        }
        return super.onTargetHit(minigun, ammo, target);
    }

    @Override
    public int onBlockHit(Minigun minigun, ItemStack ammo, BlockHitResult brtr) {
        ItemStack potion = StandardGunAmmoItem.getPotion(ammo);
        if (potion.getItem() == Items.SPLASH_POTION || potion.getItem() == Items.LINGERING_POTION) {
            Player shooter = minigun.getPlayer();
            int chance = (Integer)ConfigHelper.common().minigun.potionProcChance.get() + minigun.getUpgrades(ModUpgrades.DISPENSER.get()) * 2;
            if (shooter.level().random.nextInt(100) < chance) {
                ThrownPotion entityPotion = new ThrownPotion(shooter.level(), (LivingEntity)shooter);
                entityPotion.setItem(potion);
                BlockPos pos2 = brtr.getBlockPos().relative(brtr.getDirection());
                entityPotion.setPos((double)pos2.getX() + 0.5, (double)pos2.getY() + 0.5, (double)pos2.getZ() + 0.5);
                shooter.level().addFreshEntity((Entity)entityPotion);
            }
            return StandardGunAmmoItem.getPotionAmmoCost(potion.getItem());
        }
        return super.onBlockHit(minigun, ammo, brtr);
    }

    private static int getPotionAmmoCost(Item item) {
        if (item == Items.LINGERING_POTION) {
            return 6;
        }
        if (item == Items.SPLASH_POTION) {
            return 3;
        }
        if (item == Items.POTION) {
            return 1;
        }
        throw new IllegalArgumentException("Item " + item + " is not a potion!");
    }
}

