/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.IRedstoneControl;
import me.desht.pneumaticcraft.common.block.entity.ISerializableTanks;
import me.desht.pneumaticcraft.common.block.entity.ISideConfigurable;
import me.desht.pneumaticcraft.common.block.entity.SideConfigurator;
import me.desht.pneumaticcraft.common.registry.ModLootFunctions;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import me.desht.pneumaticcraft.common.util.NBTUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootFunc {

    public static class BlockEntitySerializerFunction
    extends LootItemConditionalFunction {
        public static final Codec<BlockEntitySerializerFunction> CODEC = RecordCodecBuilder.create(instance -> BlockEntitySerializerFunction.commonFields((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, BlockEntitySerializerFunction::new));

        private BlockEntitySerializerFunction(List<LootItemCondition> conditionsIn) {
            super(conditionsIn);
        }

        protected ItemStack run(ItemStack stack, LootContext context) {
            return this.applyBEdata(stack, (BlockEntity)context.getParamOrNull(LootContextParams.BLOCK_ENTITY));
        }

        public static LootItemConditionalFunction.Builder<?> builder() {
            return BlockEntitySerializerFunction.simpleBuilder(BlockEntitySerializerFunction::new);
        }

        private ItemStack applyBEdata(ItemStack teStack, BlockEntity te) {
            ISideConfigurable sc;
            CompoundTag tag;
            ISerializableTanks s;
            CompoundTag tankTag;
            CompoundTag subTag;
            CompoundTag nbt = teStack.getTagElement("BlockEntityTag");
            CompoundTag compoundTag = subTag = nbt == null ? new CompoundTag() : nbt;
            if (te instanceof ISerializableTanks && !(tankTag = (s = (ISerializableTanks)te).serializeTanks()).isEmpty()) {
                subTag.put("SavedTanks", (Tag)tankTag);
            }
            if (te instanceof ISideConfigurable && !(tag = SideConfigurator.writeToNBT(sc = (ISideConfigurable)te)).isEmpty()) {
                subTag.put("SideConfiguration", (Tag)tag);
            }
            if (te instanceof IRedstoneControl) {
                IRedstoneControl rc = (IRedstoneControl)te;
                rc.getRedstoneController().serialize(subTag);
            }
            if (te instanceof AbstractPneumaticCraftBlockEntity) {
                AbstractPneumaticCraftBlockEntity teB = (AbstractPneumaticCraftBlockEntity)te;
                if (teB.shouldPreserveStateOnBreak()) {
                    IAirHandlerMachine handler;
                    AbstractPneumaticCraftBlockEntity.UpgradeHandler upgradeHandler = teB.getUpgradeHandler();
                    for (int i = 0; i < upgradeHandler.getSlots(); ++i) {
                        if (upgradeHandler.getStackInSlot(i).isEmpty()) continue;
                        if (teB.getUpgrades(ModUpgrades.CREATIVE.get()) > 0) {
                            NBTUtils.setBoolean(teStack, "CreativeUpgrade", true);
                        } else {
                            NBTUtils.removeTag(teStack, "CreativeUpgrade");
                        }
                        subTag.put("UpgradeInventory", (Tag)upgradeHandler.serializeNBT());
                        break;
                    }
                    if ((handler = (IAirHandlerMachine)te.getLevel().getCapability(PNCCapabilities.AIR_HANDLER_MACHINE, te.getBlockPos(), te.getBlockState(), te, null)) != null && handler.getPressure() != 0.0f) {
                        subTag.putInt("AirAmount", handler.getAir());
                    }
                }
                teB.serializeExtraItemData(subTag, teB.shouldPreserveStateOnBreak());
            }
            if (!subTag.isEmpty()) {
                CompoundTag tag2 = teStack.getOrCreateTag();
                tag2.put("BlockEntityTag", (Tag)subTag);
            } else if (teStack.hasTag() && Objects.requireNonNull(teStack.getTag()).contains("BlockEntityTag")) {
                teStack.getTag().remove("BlockEntityTag");
            }
            return teStack;
        }

        public LootItemFunctionType getType() {
            return ModLootFunctions.TE_SERIALIZER.get();
        }
    }
}

