/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class PNCDungeonLootModifier
extends LootModifier {
    public static final Supplier<Codec<PNCDungeonLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> PNCDungeonLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, PNCDungeonLootModifier::new)));

    public PNCDungeonLootModifier(LootItemCondition[] conditions) {
        super(conditions);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (((Boolean)ConfigHelper.common().general.enableDungeonLoot.get()).booleanValue()) {
            generatedLoot.addAll(CustomPools.roll(context));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }

    private static class CustomPools {
        private static LootPool commonPool = null;
        private static LootPool uncommonPool = null;
        private static LootPool rarePool = null;

        private CustomPools() {
        }

        private static List<ItemStack> roll(LootContext ctx) {
            if (commonPool == null) {
                commonPool = CustomPools.buildLootPool("common");
                uncommonPool = CustomPools.buildLootPool("uncommon");
                rarePool = CustomPools.buildLootPool("rare");
            }
            ArrayList<ItemStack> res = new ArrayList<ItemStack>();
            commonPool.addRandomItems(res::add, ctx);
            uncommonPool.addRandomItems(res::add, ctx);
            rarePool.addRandomItems(res::add, ctx);
            return res;
        }

        private static LootPool buildLootPool(String name) {
            return LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootTableReference.lootTableReference((ResourceLocation)PneumaticRegistry.RL("custom/" + name + "_dungeon_loot")).setWeight(1)).name("pneumaticcraft_custom_" + name).build();
        }
    }
}

