/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.network.DronePacket;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderResponse;
import me.desht.pneumaticcraft.common.network.PacketAmadronOrderUpdate;
import me.desht.pneumaticcraft.common.network.PacketAmadronStockUpdate;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeAddCustom;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeNotifyDeal;
import me.desht.pneumaticcraft.common.network.PacketAmadronTradeRemoved;
import me.desht.pneumaticcraft.common.network.PacketAphorismTileUpdate;
import me.desht.pneumaticcraft.common.network.PacketChangeGPSToolCoordinate;
import me.desht.pneumaticcraft.common.network.PacketChestplateLauncher;
import me.desht.pneumaticcraft.common.network.PacketClearRecipeCache;
import me.desht.pneumaticcraft.common.network.PacketDebugBlock;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.PacketDescriptionPacketRequest;
import me.desht.pneumaticcraft.common.network.PacketGuiButton;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingBlockStart;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityFinish;
import me.desht.pneumaticcraft.common.network.PacketHackingEntityStart;
import me.desht.pneumaticcraft.common.network.PacketJetBootsActivate;
import me.desht.pneumaticcraft.common.network.PacketJetBootsStateSync;
import me.desht.pneumaticcraft.common.network.PacketLeftClickEmpty;
import me.desht.pneumaticcraft.common.network.PacketMinigunStop;
import me.desht.pneumaticcraft.common.network.PacketModWrenchBlock;
import me.desht.pneumaticcraft.common.network.PacketMultiHeader;
import me.desht.pneumaticcraft.common.network.PacketMultiPart;
import me.desht.pneumaticcraft.common.network.PacketNotifyBlockUpdate;
import me.desht.pneumaticcraft.common.network.PacketPlayMovingSound;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.network.PacketPneumaticKick;
import me.desht.pneumaticcraft.common.network.PacketProgrammerSync;
import me.desht.pneumaticcraft.common.network.PacketSendArmorHUDMessage;
import me.desht.pneumaticcraft.common.network.PacketSendDroneDebugEntry;
import me.desht.pneumaticcraft.common.network.PacketSendNBTPacket;
import me.desht.pneumaticcraft.common.network.PacketServerTickTime;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.network.PacketShiftScrollWheel;
import me.desht.pneumaticcraft.common.network.PacketShowArea;
import me.desht.pneumaticcraft.common.network.PacketShowWireframe;
import me.desht.pneumaticcraft.common.network.PacketSpawnIndicatorParticles;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticleTrail;
import me.desht.pneumaticcraft.common.network.PacketSpawnRing;
import me.desht.pneumaticcraft.common.network.PacketSyncAmadronOffers;
import me.desht.pneumaticcraft.common.network.PacketSyncClassifyFilter;
import me.desht.pneumaticcraft.common.network.PacketSyncDroneProgWidgets;
import me.desht.pneumaticcraft.common.network.PacketSyncEntityHacks;
import me.desht.pneumaticcraft.common.network.PacketSyncHackSimulationUpdate;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToClient;
import me.desht.pneumaticcraft.common.network.PacketSyncRedstoneModuleToServer;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.network.PacketSyncSmartChest;
import me.desht.pneumaticcraft.common.network.PacketSyncThermostatModuleToClient;
import me.desht.pneumaticcraft.common.network.PacketSyncThermostatModuleToServer;
import me.desht.pneumaticcraft.common.network.PacketTeleportCommand;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeature;
import me.desht.pneumaticcraft.common.network.PacketToggleArmorFeatureBulk;
import me.desht.pneumaticcraft.common.network.PacketTubeModuleColor;
import me.desht.pneumaticcraft.common.network.PacketUpdateAirGrateModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorColors;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.network.PacketUpdateDebuggingDrone;
import me.desht.pneumaticcraft.common.network.PacketUpdateGPSAreaTool;
import me.desht.pneumaticcraft.common.network.PacketUpdateGui;
import me.desht.pneumaticcraft.common.network.PacketUpdateLogisticsModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateMicromissileSettings;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.network.PacketUpdateRemoteLayout;
import me.desht.pneumaticcraft.common.network.PacketUpdateSearchItem;
import me.desht.pneumaticcraft.common.network.PacketUpdateTextfield;
import me.desht.pneumaticcraft.common.network.TubeModulePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="pneumaticcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";

    @SubscribeEvent
    public static void register(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("pneumaticcraft").versioned(PROTOCOL_VERSION);
        registrar.play(PacketAphorismTileUpdate.ID, PacketAphorismTileUpdate::fromNetwork, handler -> handler.server(PacketAphorismTileUpdate::handle));
        registrar.play(PacketChangeGPSToolCoordinate.ID, PacketChangeGPSToolCoordinate::new, handler -> handler.server(PacketChangeGPSToolCoordinate::handle));
        registrar.play(PacketUpdateGPSAreaTool.ID, PacketUpdateGPSAreaTool::new, handler -> handler.server(PacketUpdateGPSAreaTool::handle));
        registrar.play(PacketDescriptionPacketRequest.ID, PacketDescriptionPacketRequest::new, handler -> handler.server(PacketDescriptionPacketRequest::handle));
        registrar.play(PacketGuiButton.ID, PacketGuiButton::new, handler -> handler.server(PacketGuiButton::handle));
        registrar.play(PacketUpdateTextfield.ID, PacketUpdateTextfield::fromNetwork, handler -> handler.server(PacketUpdateTextfield::handle));
        registrar.play(PacketUpdateSearchItem.ID, PacketUpdateSearchItem::fromNetwork, handler -> handler.server(PacketUpdateSearchItem::handle));
        registrar.play(PacketUpdateRemoteLayout.ID, PacketUpdateRemoteLayout::fromNetwork, handler -> handler.server(PacketUpdateRemoteLayout::handle));
        registrar.play(PacketUpdateMicromissileSettings.ID, PacketUpdateMicromissileSettings::fromNetwork, handler -> handler.server(PacketUpdateMicromissileSettings::handle));
        registrar.play(PacketModWrenchBlock.ID, PacketModWrenchBlock::fromNetwork, handler -> handler.server(PacketModWrenchBlock::handle));
        registrar.play(PacketLeftClickEmpty.ID, PacketLeftClickEmpty::fromNetwork, handler -> handler.server(PacketLeftClickEmpty::handle));
        registrar.play(PacketShiftScrollWheel.ID, PacketShiftScrollWheel::fromNetwork, handler -> handler.server(PacketShiftScrollWheel::handle));
        registrar.play(PacketSyncClassifyFilter.ID, PacketSyncClassifyFilter::fromNetwork, handler -> handler.server(PacketSyncClassifyFilter::handle));
        registrar.play(PacketTeleportCommand.ID, PacketTeleportCommand::fromNetwork, handler -> handler.server(PacketTeleportCommand::handle));
        registrar.play(PacketDescription.ID, PacketDescription::fromNetwork, handler -> handler.client(PacketDescription::handle));
        registrar.play(PacketPlaySound.ID, PacketPlaySound::new, handler -> handler.client(PacketPlaySound::handle));
        registrar.play(PacketSendNBTPacket.ID, PacketSendNBTPacket::fromNetwork, handler -> handler.client(PacketSendNBTPacket::handle));
        registrar.play(PacketSpawnParticle.ID, PacketSpawnParticle::fromNetwork, handler -> handler.client(PacketSpawnParticle::handle));
        registrar.play(PacketSpawnParticleTrail.ID, PacketSpawnParticleTrail::fromNetwork, handler -> handler.client(PacketSpawnParticleTrail::handle));
        registrar.play(PacketSpawnIndicatorParticles.ID, PacketSpawnIndicatorParticles::fromNetwork, handler -> handler.client(PacketSpawnIndicatorParticles::handle));
        registrar.play(PacketUpdatePressureBlock.ID, PacketUpdatePressureBlock::fromNetwork, handler -> handler.client(PacketUpdatePressureBlock::handle));
        registrar.play(PacketUpdateGui.ID, PacketUpdateGui::fromNetwork, handler -> handler.client(PacketUpdateGui::handle));
        registrar.play(PacketServerTickTime.ID, PacketServerTickTime::fromNetwork, handler -> handler.client(PacketServerTickTime::handle));
        registrar.play(PacketSpawnRing.ID, PacketSpawnRing::fromNetwork, handler -> handler.client(PacketSpawnRing::handle));
        registrar.play(PacketShowArea.ID, PacketShowArea::fromNetwork, handler -> handler.client(PacketShowArea::handle));
        registrar.play(PacketSetEntityMotion.ID, PacketSetEntityMotion::fromNetwork, handler -> handler.client(PacketSetEntityMotion::handle));
        registrar.play(PacketDebugBlock.ID, PacketDebugBlock::fromNetwork, handler -> handler.client(PacketDebugBlock::handle));
        registrar.play(PacketPlayMovingSound.ID, PacketPlayMovingSound::fromNetwork, handler -> handler.client(PacketPlayMovingSound::handle));
        registrar.play(PacketNotifyBlockUpdate.ID, PacketNotifyBlockUpdate::fromNetwork, handler -> handler.client(PacketNotifyBlockUpdate::handle));
        registrar.play(PacketMinigunStop.ID, PacketMinigunStop::fromNetwork, handler -> handler.client(PacketMinigunStop::handle));
        registrar.play(PacketClearRecipeCache.ID, PacketClearRecipeCache::fromNetwork, handler -> handler.client(PacketClearRecipeCache::handle));
        registrar.play(PacketSetGlobalVariable.ID, PacketSetGlobalVariable::fromNetwork, handler -> handler.client(PacketSetGlobalVariable::handle).server(PacketSetGlobalVariable::handle));
        registrar.play(PacketSyncSemiblock.ID, PacketSyncSemiblock::fromNetwork, handler -> handler.client(PacketSyncSemiblock::handle).server(PacketSyncSemiblock::handle));
        registrar.play(PacketSyncSmartChest.ID, PacketSyncSmartChest::fromNetwork, handler -> handler.client(PacketSyncSmartChest::handle).server(PacketSyncSmartChest::handle));
        registrar.play(PacketUpdatePressureModule.ID, PacketUpdatePressureModule::fromNetwork, handler -> handler.server(TubeModulePacket::handle));
        registrar.play(PacketUpdateAirGrateModule.ID, PacketUpdateAirGrateModule::fromNetwork, handler -> handler.server(TubeModulePacket::handle));
        registrar.play(PacketTubeModuleColor.ID, PacketTubeModuleColor::fromNetwork, handler -> handler.server(TubeModulePacket::handle));
        registrar.play(PacketSyncRedstoneModuleToServer.ID, PacketSyncRedstoneModuleToServer::fromNetwork, handler -> handler.server(TubeModulePacket::handle));
        registrar.play(PacketUpdateLogisticsModule.ID, PacketUpdateLogisticsModule::fromNetwork, handler -> handler.client(TubeModulePacket::handle));
        registrar.play(PacketSyncRedstoneModuleToClient.ID, PacketSyncRedstoneModuleToClient::fromNetwork, handler -> handler.client(TubeModulePacket::handle));
        registrar.play(PacketSyncThermostatModuleToClient.ID, PacketSyncThermostatModuleToClient::fromNetwork, handler -> handler.client(TubeModulePacket::handle));
        registrar.play(PacketSyncThermostatModuleToServer.ID, PacketSyncThermostatModuleToServer::fromNetwork, handler -> handler.server(TubeModulePacket::handle));
        registrar.play(PacketSyncAmadronOffers.ID, PacketSyncAmadronOffers::fromNetwork, handler -> handler.client(PacketSyncAmadronOffers::handle).server(PacketSyncAmadronOffers::handle));
        registrar.play(PacketAmadronOrderResponse.ID, PacketAmadronOrderResponse::fromNetwork, handler -> handler.client(PacketAmadronOrderResponse::handle));
        registrar.play(PacketAmadronOrderUpdate.ID, PacketAmadronOrderUpdate::fromNetwork, handler -> handler.server(PacketAmadronOrderUpdate::handle));
        registrar.play(PacketAmadronStockUpdate.ID, PacketAmadronStockUpdate::fromNetwork, handler -> handler.client(PacketAmadronStockUpdate::handle));
        registrar.play(PacketAmadronTradeNotifyDeal.ID, PacketAmadronTradeNotifyDeal::fromNetwork, handler -> handler.client(PacketAmadronTradeNotifyDeal::handle));
        registrar.play(PacketAmadronTradeRemoved.ID, PacketAmadronTradeRemoved::fromNetwork, handler -> handler.client(PacketAmadronTradeRemoved::handle));
        registrar.play(PacketAmadronTradeAddCustom.ID, PacketAmadronTradeAddCustom::fromNetwork, handler -> handler.client(PacketAmadronTradeAddCustom::handle).server(PacketAmadronTradeAddCustom::handle));
        registrar.play(PacketHackingBlockStart.ID, PacketHackingBlockStart::fromNetwork, handler -> handler.client(PacketHackingBlockStart::handle).server(PacketHackingBlockStart::handle));
        registrar.play(PacketHackingEntityStart.ID, PacketHackingEntityStart::fromNetwork, handler -> handler.client(PacketHackingEntityStart::handle).server(PacketHackingEntityStart::handle));
        registrar.play(PacketHackingBlockFinish.ID, PacketHackingBlockFinish::fromNetwork, handler -> handler.client(PacketHackingBlockFinish::handle));
        registrar.play(PacketHackingEntityFinish.ID, PacketHackingEntityFinish::fromNetwork, handler -> handler.client(PacketHackingEntityFinish::handle));
        registrar.play(PacketSyncHackSimulationUpdate.ID, PacketSyncHackSimulationUpdate::fromNetwork, handler -> handler.client(PacketSyncHackSimulationUpdate::handle));
        registrar.play(PacketSyncEntityHacks.ID, PacketSyncEntityHacks::fromNetwork, handler -> handler.client(PacketSyncEntityHacks::handle));
        registrar.play(PacketToggleArmorFeature.ID, PacketToggleArmorFeature::fromNetwork, handler -> handler.server(PacketToggleArmorFeature::handle).client(PacketToggleArmorFeature::handle));
        registrar.play(PacketToggleArmorFeatureBulk.ID, PacketToggleArmorFeatureBulk::fromNetwork, handler -> handler.server(PacketToggleArmorFeatureBulk::handle));
        registrar.play(PacketPneumaticKick.ID, PacketPneumaticKick::fromNetwork, handler -> handler.server(PacketPneumaticKick::handle));
        registrar.play(PacketJetBootsActivate.ID, PacketJetBootsActivate::fromNetwork, handler -> handler.server(PacketJetBootsActivate::handle));
        registrar.play(PacketChestplateLauncher.ID, PacketChestplateLauncher::fromNetwork, handler -> handler.server(PacketChestplateLauncher::handle));
        registrar.play(PacketUpdateArmorColors.ID, PacketUpdateArmorColors::fromNetwork, handler -> handler.server(PacketUpdateArmorColors::handle));
        registrar.play(PacketUpdateArmorExtraData.ID, PacketUpdateArmorExtraData::fromNetwork, handler -> handler.server(PacketUpdateArmorExtraData::handle));
        registrar.play(PacketJetBootsStateSync.ID, PacketJetBootsStateSync::fromNetwork, handler -> handler.client(PacketJetBootsStateSync::handle));
        registrar.play(PacketSendArmorHUDMessage.ID, PacketSendArmorHUDMessage::fromNetwork, handler -> handler.client(PacketSendArmorHUDMessage::handle));
        registrar.play(PacketUpdateDebuggingDrone.ID, PacketUpdateDebuggingDrone::fromNetwork, handler -> handler.server(DronePacket::handle));
        registrar.play(PacketSendDroneDebugEntry.ID, PacketSendDroneDebugEntry::fromNetwork, handler -> handler.client(DronePacket::handle));
        registrar.play(PacketSyncDroneProgWidgets.ID, PacketSyncDroneProgWidgets::fromNetwork, handler -> handler.client(DronePacket::handle));
        registrar.play(PacketShowWireframe.ID, PacketShowWireframe::fromNetwork, handler -> handler.client(PacketShowWireframe::handle));
        registrar.play(PacketProgrammerSync.ID, PacketProgrammerSync::fromNetwork, handler -> handler.client(PacketProgrammerSync::handle).server(PacketProgrammerSync::handle));
    }

    public static void sendToAll(CustomPacketPayload message) {
        NetworkHandler.sendMessage(message, msg -> PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{msg}));
    }

    public static void sendToPlayer(CustomPacketPayload message, ServerPlayer player) {
        NetworkHandler.sendMessage(message, msg -> PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{msg}));
    }

    public static void sendToAllTracking(CustomPacketPayload message, Entity entity) {
        NetworkHandler.sendMessage(message, msg -> PacketDistributor.TRACKING_ENTITY.with((Object)entity).send(new CustomPacketPayload[]{msg}));
    }

    public static void sendToAllTracking(CustomPacketPayload message, Level level, BlockPos pos) {
        NetworkHandler.sendMessage(message, msg -> PacketDistributor.TRACKING_CHUNK.with((Object)level.getChunkAt(pos)).send(new CustomPacketPayload[]{msg}));
    }

    public static void sendToAllTracking(CustomPacketPayload message, BlockEntity te) {
        if (te.getLevel() != null) {
            NetworkHandler.sendToAllTracking(message, te.getLevel(), te.getBlockPos());
        }
    }

    public static void sendToDimension(CustomPacketPayload message, ResourceKey<Level> level) {
        NetworkHandler.sendMessage(message, msg -> PacketDistributor.DIMENSION.with((Object)level).send(new CustomPacketPayload[]{msg}));
    }

    public static void sendToServer(CustomPacketPayload message) {
        NetworkHandler.sendMessage(message, msg -> PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{msg}));
    }

    public static void sendNonLocal(CustomPacketPayload packet) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            if (server.isDedicatedServer()) {
                NetworkHandler.sendToAll(packet);
            } else {
                for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                    if (player.server.isSingleplayerOwner(player.getGameProfile())) continue;
                    NetworkHandler.sendToPlayer(packet, player);
                }
            }
        }
    }

    public static void sendNonLocal(ServerPlayer player, CustomPacketPayload packet) {
        if (!player.server.isSingleplayerOwner(player.getGameProfile())) {
            NetworkHandler.sendToPlayer(packet, player);
        }
    }

    private static void sendMessage(CustomPacketPayload message, Consumer<CustomPacketPayload> consumer) {
        if (message instanceof ILargePayload) {
            FriendlyByteBuf buf = ((ILargePayload)message).dumpToBuffer();
            if (buf.writerIndex() < 32000) {
                consumer.accept(message);
            } else {
                ArrayList<Record> messageParts = new ArrayList<Record>();
                messageParts.add(new PacketMultiHeader(buf.writerIndex(), message.getClass().getName()));
                byte[] bytes = buf.array();
                for (int offset = 0; offset < buf.writerIndex(); offset += 32000) {
                    messageParts.add(new PacketMultiPart(Arrays.copyOfRange(bytes, offset, Math.min(offset + 32000, buf.writerIndex()))));
                }
                messageParts.forEach(consumer);
            }
        } else {
            consumer.accept(message);
        }
    }
}

