/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.gui.AmadronScreen;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketAmadronOrderResponse(ResourceLocation offerId, int amount) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("amadron_order_response");

    public static PacketAmadronOrderResponse fromNetwork(FriendlyByteBuf buf) {
        return new PacketAmadronOrderResponse(buf.readResourceLocation(), buf.readVarInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.offerId);
        buf.writeVarInt(this.amount);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketAmadronOrderResponse message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Player player = ClientUtils.getClientPlayer();
            if (player.containerMenu instanceof AmadronMenu) {
                ((AmadronMenu)player.containerMenu).updateBasket(message.offerId(), message.amount());
                AmadronScreen.basketUpdated();
            }
        });
    }
}

