/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.inventory.AmadronMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketAmadronOrderUpdate(ResourceLocation orderId, int mouseButton, boolean sneaking) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("amadron_order_update");

    public static PacketAmadronOrderUpdate fromNetwork(FriendlyByteBuf buffer) {
        return new PacketAmadronOrderUpdate(buffer.readResourceLocation(), buffer.readByte(), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.orderId);
        buf.writeByte(this.mouseButton);
        buf.writeBoolean(this.sneaking);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketAmadronOrderUpdate message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                AbstractContainerMenu patt2269$temp = player.containerMenu;
                if (patt2269$temp instanceof AmadronMenu) {
                    AmadronMenu menu = (AmadronMenu)patt2269$temp;
                    menu.clickOffer(message.orderId(), message.mouseButton(), message.sneaking(), sp);
                }
            }
        }));
    }
}

