/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketAmadronStockUpdate(ResourceLocation id, int stock) implements CustomPacketPayload
{
    private final ResourceLocation id;
    public static final ResourceLocation ID = PneumaticRegistry.RL("amadron_stock_update");

    public static PacketAmadronStockUpdate fromNetwork(FriendlyByteBuf buffer) {
        return new PacketAmadronStockUpdate(buffer.readResourceLocation(), buffer.readVarInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.id);
        buf.writeVarInt(this.stock);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketAmadronStockUpdate message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> AmadronOfferManager.getInstance().updateStock(message.id(), message.stock()));
    }
}

