/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.inventory.AmadronAddTradeMenu;
import me.desht.pneumaticcraft.common.item.AmadronTabletItem;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketAmadronTradeAddCustom(AmadronPlayerOffer offer) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("amadron_add_custom_trade");

    public static PacketAmadronTradeAddCustom fromNetwork(FriendlyByteBuf buffer) {
        return new PacketAmadronTradeAddCustom(AmadronPlayerOffer.playerOfferFromBuf(buffer));
    }

    public static void handle(PacketAmadronTradeAddCustom message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            if (ctx.flow().isClientbound()) {
                message.handleClientSide((Player)player);
            } else if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                message.handleServerSide(sp);
            }
        }));
    }

    public void write(FriendlyByteBuf buf) {
        this.offer.write(buf);
    }

    public ResourceLocation id() {
        return ID;
    }

    private void handleClientSide(Player player) {
        if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeAddition.get()).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"pneumaticcraft.message.amadron.playerAddedTrade", (Object[])new Object[]{this.offer.getVendorName(), this.offer.getOutput().toString(), this.offer.getInput().toString()}), false);
        }
    }

    private void handleServerSide(ServerPlayer player) {
        if (player.containerMenu instanceof AmadronAddTradeMenu) {
            this.offer.updatePlayerId();
            if (AmadronOfferManager.getInstance().hasSimilarPlayerOffer(this.offer.getReversedOffer())) {
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.duplicateReversedOffer", new Object[0]), false);
            } else if (AmadronOfferManager.getInstance().addPlayerOffer(this.offer)) {
                if (((Boolean)ConfigHelper.common().amadron.notifyOfTradeAddition.get()).booleanValue()) {
                    NetworkHandler.sendToAll(this);
                }
                if (player.getMainHandItem().getItem() == ModItems.AMADRON_TABLET.get()) {
                    AmadronTabletItem.openGui(player, InteractionHand.MAIN_HAND);
                } else if (player.getOffhandItem().getItem() == ModItems.AMADRON_TABLET.get()) {
                    AmadronTabletItem.openGui(player, InteractionHand.OFF_HAND);
                }
            } else {
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.duplicateOffer", new Object[0]), false);
            }
        }
    }
}

