/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronPlayerOffer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketAmadronTradeNotifyDeal(AmadronPlayerOffer offer, int offerAmount, String buyingPlayer) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("amadron_notify_deal");

    public static PacketAmadronTradeNotifyDeal fromNetwork(FriendlyByteBuf buffer) {
        return new PacketAmadronTradeNotifyDeal(AmadronPlayerOffer.playerOfferFromBuf(buffer), buffer.readInt(), buffer.readUtf());
    }

    public void write(FriendlyByteBuf buf) {
        this.offer.write(buf);
        buf.writeInt(this.offerAmount);
        buf.writeUtf(this.buyingPlayer);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketAmadronTradeNotifyDeal message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            if (((Boolean)ConfigHelper.common().amadron.notifyOfDealMade.get()).booleanValue()) {
                player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.amadron.playerBought", message.buyingPlayer(), message.offerAmount(), message.offer().getOutput().toString(), message.offer().getInput().toString()), false);
            }
        }));
    }
}

