/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Arrays;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.AphorismTileBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.AphorismTileBlockEntity;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketAphorismTileUpdate(BlockPos pos, String[] text, int textRotation, byte margin, boolean invis) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("aphorism_tile_update");
    private static final int MAX_LENGTH = 1024;

    public static PacketAphorismTileUpdate fromNetwork(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        byte textRotation = buffer.readByte();
        int lines = buffer.readVarInt();
        String[] text = new String[lines];
        for (int i = 0; i < lines; ++i) {
            text[i] = buffer.readUtf(1024);
        }
        byte margin = buffer.readByte();
        boolean invis = buffer.readBoolean();
        return new PacketAphorismTileUpdate(pos, text, textRotation, margin, invis);
    }

    public static PacketAphorismTileUpdate forBlockEntity(AphorismTileBlockEntity blockEntity) {
        return new PacketAphorismTileUpdate(blockEntity.getBlockPos(), blockEntity.getTextLines(), blockEntity.getTextRotation(), blockEntity.getMarginSize(), (Boolean)blockEntity.getBlockState().getValue((Property)AphorismTileBlock.INVISIBLE));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeByte(this.textRotation);
        buffer.writeVarInt(this.text.length);
        Arrays.stream(this.text).forEach(s -> buffer.writeUtf(s, 1024));
        buffer.writeByte(this.margin);
        buffer.writeBoolean(this.invis);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketAphorismTileUpdate message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Player player = (Player)ctx.player().orElseThrow();
            if (PneumaticCraftUtils.canPlayerReach(player, message.pos())) {
                PneumaticCraftUtils.getTileEntityAt((BlockGetter)player.level(), message.pos(), AphorismTileBlockEntity.class).ifPresent(te -> {
                    te.setTextLines(message.text(), false);
                    te.setTextRotation(message.textRotation());
                    te.setMarginSize(message.margin());
                    te.setInvisible(message.invis());
                });
            }
        });
    }
}

