/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.SyncedField;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketDescription(BlockPos pos, boolean fullSync, List<IndexedField> fields, CompoundTag extraData) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("description");

    public static PacketDescription create(IDescSynced te, boolean fullSync) {
        ArrayList<IndexedField> fields = new ArrayList<IndexedField>();
        List<SyncedField<?>> descFields = te.getDescriptionFields();
        for (int i = 0; i < descFields.size(); ++i) {
            if (!fullSync && !te.shouldSyncField(i)) continue;
            fields.add(new IndexedField(i, SyncedField.getType(descFields.get(i)), descFields.get(i).getValue()));
        }
        CompoundTag extraData = (CompoundTag)Util.make((Object)new CompoundTag(), te::writeToPacket);
        return new PacketDescription(te.getPosition(), fullSync, fields, extraData);
    }

    public static PacketDescription fromNetwork(FriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        boolean fullSync = buf.readBoolean();
        int fieldCount = buf.readVarInt();
        ArrayList<IndexedField> fields = new ArrayList<IndexedField>();
        for (int i = 0; i < fieldCount; ++i) {
            int idx = fullSync ? i : buf.readVarInt();
            byte type = buf.readByte();
            fields.add(new IndexedField(idx, type, SyncedField.fromBytes(buf, type)));
        }
        CompoundTag extraData = buf.readNbt();
        return new PacketDescription(pos, fullSync, fields, extraData);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.fullSync);
        buf.writeVarInt(this.fields.size());
        for (IndexedField indexedField : this.fields) {
            if (!this.fullSync) {
                buf.writeVarInt(indexedField.idx);
            }
            buf.writeByte(indexedField.type);
            SyncedField.toBytes(buf, indexedField.value, indexedField.type);
        }
        buf.writeNbt((Tag)this.extraData);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketDescription message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> message.processPacket(null));
    }

    public void processPacket(BlockEntity blockEntity) {
        if (blockEntity == null) {
            if (!ClientUtils.getClientLevel().isLoaded(this.pos)) {
                return;
            }
            blockEntity = ClientUtils.getBlockEntity(this.pos);
        }
        if (blockEntity instanceof IDescSynced) {
            IDescSynced descSynced = (IDescSynced)blockEntity;
            List<SyncedField<?>> descFields = descSynced.getDescriptionFields();
            if (descFields != null) {
                for (IndexedField indexedField : this.fields) {
                    if (indexedField.idx >= descFields.size()) continue;
                    descFields.get(indexedField.idx).setValue(indexedField.value);
                }
            }
            descSynced.readFromPacket(this.extraData);
            descSynced.onDescUpdate();
        }
    }

    public CompoundTag writeNBT(CompoundTag compound) {
        CompoundTag subTag = new CompoundTag();
        subTag.putInt("Length", this.fields.size());
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        ListTag list = new ListTag();
        for (IndexedField field : this.fields) {
            CompoundTag element = new CompoundTag();
            element.putByte("Type", field.type);
            buf.clear();
            SyncedField.toBytes(buf, field.value, field.type);
            element.putByteArray("Value", Arrays.copyOf(buf.array(), buf.writerIndex()));
            list.add(list.size(), (Tag)element);
        }
        buf.release();
        subTag.put("Data", (Tag)list);
        subTag.put("Extra", (Tag)this.extraData);
        compound.put("pneumaticcraft", (Tag)subTag);
        return compound;
    }

    public static PacketDescription fromNBT(CompoundTag compound) {
        BlockPos pos = new BlockPos(compound.getInt("x"), compound.getInt("y"), compound.getInt("z"));
        boolean fullSync = true;
        CompoundTag subTag = compound.getCompound("pneumaticcraft");
        int fieldCount = subTag.getInt("Length");
        ArrayList<IndexedField> fields = new ArrayList<IndexedField>();
        ListTag list = subTag.getList("Data", 10);
        for (int i = 0; i < fieldCount; ++i) {
            CompoundTag element = list.getCompound(i);
            byte type = element.getByte("Type");
            byte[] b = element.getByteArray("Value");
            fields.add(new IndexedField(i, type, SyncedField.fromBytes(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])b)), type)));
        }
        CompoundTag extraData = subTag.getCompound("Extra");
        return new PacketDescription(pos, fullSync, fields, extraData);
    }

    public boolean hasData() {
        return !this.fields.isEmpty() || !this.extraData.isEmpty();
    }

    private record IndexedField(int idx, byte type, Object value) {
    }
}

