/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSendNBTPacket;
import me.desht.pneumaticcraft.common.pneumatic_armor.BlockTrackLootable;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketDescriptionPacketRequest(BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("description_request");

    public PacketDescriptionPacketRequest(FriendlyByteBuf buffer) {
        this(buffer.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketDescriptionPacketRequest message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (!player.isSpectator()) {
                    ctx.workHandler().submitAsync(() -> {
                        BlockEntity blockEntity;
                        CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
                        if (handler.upgradeUsable(CommonUpgradeHandlers.blockTrackerHandler, true) && (blockEntity = player.level().getBlockEntity(message.pos)) != null) {
                            BlockTrackLootable.INSTANCE.apply((Player)player, blockEntity);
                            NetworkHandler.sendToPlayer(PacketSendNBTPacket.forBlockEntity(blockEntity), sp);
                        }
                    });
                }
            }
        });
    }
}

