/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketGuiButton(String tag, boolean shiftHeld) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("gui_button");

    public PacketGuiButton(String tag) {
        this(tag, ClientUtils.hasShiftDown());
    }

    public PacketGuiButton(FriendlyByteBuf buffer) {
        this(buffer.readUtf(1024), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.tag);
        buffer.writeBoolean(this.shiftHeld);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketGuiButton message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                AbstractContainerMenu patt2153$temp = sp.containerMenu;
                if (patt2153$temp instanceof IGUIButtonSensitive) {
                    IGUIButtonSensitive gbs = (IGUIButtonSensitive)patt2153$temp;
                    gbs.handleGUIButtonPress(message.tag, message.shiftHeld, sp);
                }
            }
        }));
    }
}

