/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableBlock;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.hacking.HackTickTracker;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketHackingBlockFinish(BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("hack_block_finish");

    public static PacketHackingBlockFinish create(WorldAndCoord gPos) {
        return new PacketHackingBlockFinish(gPos.pos);
    }

    public static PacketHackingBlockFinish fromNetwork(FriendlyByteBuf buffer) {
        return new PacketHackingBlockFinish(buffer.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketHackingBlockFinish message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            IHackableBlock hackableBlock = HackManager.getHackableForBlock((BlockGetter)player.level(), message.pos(), player);
            if (hackableBlock != null) {
                hackableBlock.onHackComplete(player.level(), message.pos(), (Player)player);
                HackTickTracker.getInstance(player.level()).trackBlock(message.pos(), hackableBlock);
                CommonArmorHandler.getHandlerForPlayer(player).getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedBlockPos(null);
                player.playSound((SoundEvent)ModSounds.HELMET_HACK_FINISH.get(), 1.0f, 1.0f);
            }
        }));
    }
}

