/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.BlockTrackerClientHandler;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.RenderBlockTarget;
import me.desht.pneumaticcraft.common.hacking.WorldAndCoord;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketHackingBlockStart(BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("hack_block_start");

    public static PacketHackingBlockStart fromNetwork(FriendlyByteBuf buffer) {
        return new PacketHackingBlockStart(buffer.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketHackingBlockStart message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            if (ctx.flow().isClientbound()) {
                CommonArmorHandler.getHandlerForPlayer().getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedBlockPos(new WorldAndCoord((BlockGetter)player.level(), message.pos()));
                RenderBlockTarget target = ClientArmorRegistry.getInstance().getClientHandler(CommonUpgradeHandlers.blockTrackerHandler, BlockTrackerClientHandler.class).getTargetForCoord(message.pos());
                if (target != null) {
                    target.onHackConfirmServer();
                }
            } else if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
                if (handler.upgradeUsable(CommonUpgradeHandlers.blockTrackerHandler, true)) {
                    handler.getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedBlockPos(new WorldAndCoord((BlockGetter)player.level(), message.pos()));
                    NetworkHandler.sendToPlayer(message, sp);
                }
            }
        }));
    }
}

