/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pneumatic_armor.hacking.IHackableEntity;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.hacking.HackTickTracker;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketHackingEntityFinish(int entityId) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("hack_entity_finish");

    public static PacketHackingEntityFinish forEntity(Entity entity) {
        return new PacketHackingEntityFinish(entity.getId());
    }

    public static PacketHackingEntityFinish fromNetwork(FriendlyByteBuf buffer) {
        return new PacketHackingEntityFinish(buffer.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketHackingEntityFinish message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            IHackableEntity<?> hackableEntity;
            Entity entity = player.level().getEntity(message.entityId());
            if (entity != null && (hackableEntity = HackManager.getHackableForEntity(entity, player)) != null) {
                hackableEntity._onHackFinished(entity, (Player)player);
                HackTickTracker.getInstance(entity.level()).trackEntity(entity, hackableEntity);
                CommonArmorHandler.getHandlerForPlayer(player).getExtensionData(CommonUpgradeHandlers.hackHandler).setHackedEntity(null);
                player.playSound((SoundEvent)ModSounds.HELMET_HACK_FINISH.get(), 1.0f, 1.0f);
            }
        }));
    }
}

