/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonUpgradeHandlers;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import me.desht.pneumaticcraft.common.upgrades.ModUpgrades;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketJetBootsActivate(boolean state) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("jetboots_activate");

    public static PacketJetBootsActivate fromNetwork(FriendlyByteBuf buffer) {
        return new PacketJetBootsActivate(buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.state);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketJetBootsActivate message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            if (PneumaticArmorItem.isPneumaticArmorPiece(player, EquipmentSlot.FEET)) {
                CommonArmorHandler handler = CommonArmorHandler.getHandlerForPlayer(player);
                JetBootsStateTracker.JetBootsState jbState = JetBootsStateTracker.getTracker(player).getJetBootsState((Player)player);
                if (handler.getUpgradeCount(EquipmentSlot.FEET, ModUpgrades.JET_BOOTS.get()) > 0 && (!message.state() || jbState.isEnabled())) {
                    CommonUpgradeHandlers.jetBootsHandler.setJetBootsActive(handler, message.state());
                }
            }
        }));
    }
}

