/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.UUID;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.pneumatic_armor.JetBootsStateTracker;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketJetBootsStateSync(UUID playerId, JetBootsStateTracker.JetBootsState state) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("jetboots_state_sync");

    public static PacketJetBootsStateSync fromNetwork(FriendlyByteBuf buf) {
        return new PacketJetBootsStateSync(buf.readUUID(), JetBootsStateTracker.JetBootsState.fromNetwork(buf));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUUID(this.playerId);
        this.state.toNetwork(buf);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketJetBootsStateSync message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> JetBootsStateTracker.getTracker(ClientUtils.getClientPlayer()).syncFromServer(message.playerId(), message.state()));
    }
}

