/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.minigun.MinigunItem;
import me.desht.pneumaticcraft.common.minigun.Minigun;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketMinigunStop(ItemStack stack) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("packetminigunstop");

    public static PacketMinigunStop fromNetwork(FriendlyByteBuf buf) {
        return new PacketMinigunStop(buf.readItem());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeItem(this.stack);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketMinigunStop message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            ItemStack stack = message.stack();
            Item patt2151$temp = stack.getItem();
            if (patt2151$temp instanceof MinigunItem) {
                MinigunItem mgItem = (MinigunItem)patt2151$temp;
                Minigun minigun = mgItem.getMinigun(stack, (Player)player);
                minigun.setMinigunSpeed(0.0f);
                minigun.setMinigunActivated(false);
                minigun.setMinigunTriggerTimeOut(0);
                player.playSound((SoundEvent)ModSounds.MINIGUN_STOP.get(), 1.0f, 1.0f);
            }
        }));
    }
}

