/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.util.Either;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.block.IPneumaticWrenchable;
import me.desht.pneumaticcraft.common.thirdparty.ModdedWrenchUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketModWrenchBlock(BlockPos pos, InteractionHand hand, Either<Direction, Integer> context) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("mod_wrench_block");

    public static PacketModWrenchBlock forSide(BlockPos pos, InteractionHand hand, Direction side) {
        return new PacketModWrenchBlock(pos, hand, (Either<Direction, Integer>)Either.left((Object)side));
    }

    public static PacketModWrenchBlock forEntity(BlockPos pos, InteractionHand hand, int entityID) {
        return new PacketModWrenchBlock(pos, hand, (Either<Direction, Integer>)Either.right((Object)entityID));
    }

    public static PacketModWrenchBlock fromNetwork(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        InteractionHand hand = (InteractionHand)buffer.readEnum(InteractionHand.class);
        return buffer.readBoolean() ? new PacketModWrenchBlock(pos, hand, (Either<Direction, Integer>)Either.left((Object)((Direction)buffer.readEnum(Direction.class)))) : new PacketModWrenchBlock(pos, hand, (Either<Direction, Integer>)Either.right((Object)buffer.readInt()));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeEnum((Enum)this.hand);
        this.context.ifLeft(side -> {
            buf.writeBoolean(true);
            buf.writeEnum((Enum)side);
        }).ifRight(id -> {
            buf.writeBoolean(false);
            buf.writeInt(id.intValue());
        });
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketModWrenchBlock message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            BlockPos pos;
            Level level = player.level();
            if (level.isAreaLoaded(pos = message.pos(), 0) && PneumaticCraftUtils.canPlayerReach(player, pos)) {
                InteractionHand hand = message.hand();
                if (ModdedWrenchUtils.getInstance().isModdedWrench(player.getItemInHand(hand))) {
                    message.context().ifLeft(side -> {
                        BlockState state = level.getBlockState(pos);
                        Block patt3797$temp = state.getBlock();
                        if (patt3797$temp instanceof IPneumaticWrenchable) {
                            IPneumaticWrenchable wrenchable = (IPneumaticWrenchable)patt3797$temp;
                            wrenchable.onWrenched(level, (Player)player, pos, (Direction)side, hand);
                        }
                    }).ifRight(entityId -> {
                        Entity e = level.getEntity(entityId.intValue());
                        if (e instanceof IPneumaticWrenchable) {
                            IPneumaticWrenchable wrenchable = (IPneumaticWrenchable)e;
                            if (e.isAlive()) {
                                wrenchable.onWrenched(level, (Player)player, pos, null, hand);
                            }
                        }
                    });
                }
            }
        }));
    }
}

