/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketMultiHeader(int length, String className) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("multi_header");
    private static final Map<UUID, PayloadBuffer> payloadBuffers = new HashMap<UUID, PayloadBuffer>();

    public static PacketMultiHeader fromNetwork(FriendlyByteBuf buffer) {
        return new PacketMultiHeader(buffer.readInt(), buffer.readUtf());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.length);
        buf.writeUtf(this.className);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketMultiHeader message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = PacketMultiHeader.class.getClassLoader();
                }
                Class<?> clazz = cl.loadClass(message.className());
                payloadBuffers.put(player.getUUID(), new PayloadBuffer(clazz.asSubclass(ILargePayload.class), message.length()));
            }
            catch (ClassCastException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        }));
    }

    static void receivePayload(@Nonnull Player player, byte[] payload) {
        PayloadBuffer buffer = payloadBuffers.get(player.getUUID());
        if (buffer != null) {
            System.arraycopy(payload, 0, buffer.payload, buffer.offset, payload.length);
            buffer.offset += 32000;
            if (buffer.offset > buffer.payload.length) {
                try {
                    Constructor<? extends ILargePayload> ctor = buffer.clazz.getConstructor(FriendlyByteBuf.class);
                    ILargePayload packet = ctor.newInstance(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buffer.payload)));
                    packet.handleLargePayload(player);
                    payloadBuffers.remove(player.getUUID());
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        } else {
            Log.error("Received unexpected multi-message payload from player {} - {}", player.getGameProfile().getName(), player.getUUID());
        }
    }

    private static class PayloadBuffer {
        final Class<? extends ILargePayload> clazz;
        final byte[] payload;
        int offset;

        PayloadBuffer(Class<? extends ILargePayload> clazz, int length) {
            this.clazz = clazz;
            this.payload = new byte[length];
        }
    }
}

