/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.PacketMultiHeader;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketMultiPart(byte[] payload) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("multipart");

    public static PacketMultiPart fromNetwork(FriendlyByteBuf buf) {
        int len = buf.readInt();
        byte[] payload = (byte[])Util.make((Object)new byte[len], arg_0 -> ((FriendlyByteBuf)buf).readBytes(arg_0));
        return new PacketMultiPart(payload);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.payload.length);
        buf.writeBytes(this.payload);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketMultiPart message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> PacketMultiHeader.receivePayload(player, message.payload())));
    }
}

