/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketNotifyBlockUpdate(BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("notify_block_update");

    public static PacketNotifyBlockUpdate fromNetwork(FriendlyByteBuf buffer) {
        return new PacketNotifyBlockUpdate(buffer.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketNotifyBlockUpdate message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Level w = ClientUtils.getClientLevel();
            w.getBlockState(message.pos()).updateNeighbourShapes((LevelAccessor)w, message.pos(), 3);
        });
    }
}

