/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.util.Either;
import java.util.function.Function;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.sound.MovingSounds;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketPlayMovingSound(MovingSounds.Sound sound, MovingSoundFocus source) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("play_moving_sound");

    public static PacketPlayMovingSound fromNetwork(FriendlyByteBuf buffer) {
        return new PacketPlayMovingSound((MovingSounds.Sound)buffer.readEnum(MovingSounds.Sound.class), MovingSoundFocus.fromNetwork(buffer));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.sound);
        this.source.toNetwork(buffer);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketPlayMovingSound message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            if (message.source() != null) {
                message.source().handle(message.sound());
            }
        });
    }

    public record MovingSoundFocus(Either<Entity, BlockPos> entityOrPos) {
        public static MovingSoundFocus of(Entity e) {
            return new MovingSoundFocus((Either<Entity, BlockPos>)Either.left((Object)e));
        }

        public static MovingSoundFocus of(int id) {
            Entity e = ClientUtils.getClientLevel().getEntity(id);
            return e == null ? null : MovingSoundFocus.of(e);
        }

        public static MovingSoundFocus of(BlockPos pos) {
            return new MovingSoundFocus((Either<Entity, BlockPos>)Either.right((Object)pos));
        }

        public static MovingSoundFocus of(BlockEntity te) {
            return new MovingSoundFocus((Either<Entity, BlockPos>)Either.right((Object)te.getBlockPos()));
        }

        public static MovingSoundFocus fromNetwork(FriendlyByteBuf buf) {
            SourceType type = (SourceType)buf.readEnum(SourceType.class);
            return type.getSource(buf);
        }

        void toNetwork(FriendlyByteBuf buf) {
            this.entityOrPos.ifLeft(id -> {
                buf.writeEnum((Enum)SourceType.ENTITY);
                buf.writeInt(id.getId());
            }).ifRight(pos -> {
                buf.writeEnum((Enum)SourceType.STATIC_POS);
                buf.writeBlockPos(pos);
            });
        }

        public void handle(MovingSounds.Sound sound) {
            this.entityOrPos.ifLeft(e -> MovingSounds.playMovingSound(sound, e, new Object[0])).ifRight(pos -> MovingSounds.playMovingSound(sound, pos, new Object[0]));
        }
    }

    private static enum SourceType {
        ENTITY(buf -> MovingSoundFocus.of(buf.readInt())),
        STATIC_POS(buf -> MovingSoundFocus.of(buf.readBlockPos()));

        private final Function<FriendlyByteBuf, MovingSoundFocus> creator;

        private SourceType(Function<FriendlyByteBuf, MovingSoundFocus> creator) {
            this.creator = creator;
        }

        public MovingSoundFocus getSource(FriendlyByteBuf buf) {
            return this.creator.apply(buf);
        }
    }
}

