/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketPlaySound(SoundEvent soundEvent, SoundSource category, float x, float y, float z, float volume, float pitch, boolean distanceDelay) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("play_sound");

    public PacketPlaySound(SoundEvent soundEvent, SoundSource category, BlockPos pos, float volume, float pitch, boolean distanceDelay) {
        this(soundEvent, category, pos.getX(), pos.getY(), pos.getZ(), volume, pitch, distanceDelay);
    }

    public PacketPlaySound(FriendlyByteBuf buffer) {
        this((SoundEvent)buffer.readById((IdMap)BuiltInRegistries.SOUND_EVENT), (SoundSource)buffer.readEnum(SoundSource.class), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeId((IdMap)BuiltInRegistries.SOUND_EVENT, (Object)this.soundEvent);
        buffer.writeEnum((Enum)this.category);
        buffer.writeFloat(this.x);
        buffer.writeFloat(this.y);
        buffer.writeFloat(this.z);
        buffer.writeFloat(this.volume);
        buffer.writeFloat(this.pitch);
        buffer.writeBoolean(this.distanceDelay);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketPlaySound message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ClientUtils.getClientLevel().playLocalSound((double)message.x, (double)message.y, (double)message.z, message.soundEvent, message.category, message.volume, message.pitch, message.distanceDelay));
    }
}

