/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.Unpooled;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.entity.drone.ProgrammerBlockEntity;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.WidgetSerializer;
import me.desht.pneumaticcraft.common.network.ILargePayload;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketProgrammerSync(BlockPos pos, List<IProgWidget> widgets) implements CustomPacketPayload,
ILargePayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("programmer_sync");

    public static PacketProgrammerSync forBlockEntity(ProgrammerBlockEntity te) {
        return new PacketProgrammerSync(te.getBlockPos(), te.progWidgets);
    }

    public static PacketProgrammerSync fromNetwork(FriendlyByteBuf buffer) {
        return new PacketProgrammerSync(buffer.readBlockPos(), WidgetSerializer.readWidgetsFromPacket(buffer));
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        WidgetSerializer.writeProgWidgetsToPacket(this.widgets, buffer);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketProgrammerSync message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> message.updateTE((Player)player)));
    }

    private void updateTE(Player player) {
        PacketUtil.getBlockEntity(player, this.pos, ProgrammerBlockEntity.class).ifPresent(te -> te.setProgWidgets(this.widgets, player));
    }

    @Override
    public FriendlyByteBuf dumpToBuffer() {
        return (FriendlyByteBuf)Util.make((Object)new FriendlyByteBuf(Unpooled.buffer()), this::write);
    }

    @Override
    public void handleLargePayload(Player player) {
        this.updateTE(player);
    }
}

