/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.ArmorMessage;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.HUDHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketSendArmorHUDMessage(Component message, int duration, int color) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("send_armor_hud_message");

    public static PacketSendArmorHUDMessage fromNetwork(FriendlyByteBuf buffer) {
        return new PacketSendArmorHUDMessage(buffer.readComponent(), buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeComponent(this.message);
        buf.writeInt(this.duration);
        buf.writeInt(this.color);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSendArmorHUDMessage message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> HUDHandler.getInstance().addMessage(new ArmorMessage(message.message(), message.duration(), message.color())));
    }
}

