/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker.TrackerBlacklistManager;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketSendNBTPacket(BlockPos pos, CompoundTag tag) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("send_nbt_packet");

    public static PacketSendNBTPacket forBlockEntity(BlockEntity te) {
        return new PacketSendNBTPacket(te.getBlockPos(), te.saveWithFullMetadata());
    }

    public static PacketSendNBTPacket fromNetwork(FriendlyByteBuf buffer) {
        return new PacketSendNBTPacket(buffer.readBlockPos(), buffer.readNbt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeNbt((Tag)this.tag);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSendNBTPacket message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            BlockEntity te = ClientUtils.getBlockEntity(message.pos());
            if (te != null) {
                try {
                    te.load(message.tag());
                }
                catch (Throwable e) {
                    TrackerBlacklistManager.addInventoryTEToBlacklist(te, e);
                }
            }
        });
    }
}

