/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketServerTickTime(double tickTime) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("server_tick_time");
    public static double tickTimeMultiplier = 1.0;

    public static PacketServerTickTime fromNetwork(FriendlyByteBuf buffer) {
        return new PacketServerTickTime(buffer.readDouble());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.tickTime);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketServerTickTime message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            tickTimeMultiplier = Math.min(1.0, 50.0 / Math.max(message.tickTime(), 0.01));
            return tickTimeMultiplier;
        });
    }
}

