/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.joml.Vector3f;

public record PacketSetEntityMotion(Vector3f vec, int entityId) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("set_entity_motion");

    public static PacketSetEntityMotion create(Entity entity, Vec3 motion) {
        return new PacketSetEntityMotion(motion.toVector3f(), entity.getId());
    }

    public static PacketSetEntityMotion fromNetwork(FriendlyByteBuf buffer) {
        return new PacketSetEntityMotion(PacketUtil.readVec3f(buffer), buffer.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        PacketUtil.writeVec3f(this.vec, buf);
        buf.writeInt(this.entityId);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSetEntityMotion message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Entity entity = ClientUtils.getClientLevel().getEntity(message.entityId());
            if (entity != null) {
                entity.setDeltaMovement(new Vec3(message.vec()));
                entity.setOnGround(false);
                entity.horizontalCollision = false;
                entity.verticalCollision = false;
                if (entity instanceof LivingEntity) {
                    LivingEntity l = (LivingEntity)entity;
                    l.setJumping(true);
                }
            }
        });
    }
}

