/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import com.mojang.datafixers.util.Either;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.gui.RemoteScreen;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketSetGlobalVariable(String varName, Either<BlockPos, ItemStack> value) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("set_global_variable");

    public static PacketSetGlobalVariable forPos(String varName, @Nullable BlockPos value) {
        if (!GlobalVariableHelper.hasPrefix((String)varName)) {
            varName = "#" + (String)varName;
        }
        varName = ((String)varName).startsWith("#") ? ((String)varName).substring(1) : varName;
        return new PacketSetGlobalVariable((String)varName, (Either<BlockPos, ItemStack>)Either.left((Object)value));
    }

    public static PacketSetGlobalVariable forItem(String varName, @Nonnull ItemStack stack) {
        if (!GlobalVariableHelper.hasPrefix((String)varName)) {
            varName = "#" + (String)varName;
        }
        return new PacketSetGlobalVariable((String)varName, (Either<BlockPos, ItemStack>)Either.right((Object)stack));
    }

    public static PacketSetGlobalVariable forInt(String varName, int value) {
        return PacketSetGlobalVariable.forPos(varName, new BlockPos(value, 0, 0));
    }

    public static PacketSetGlobalVariable forBool(String varName, boolean value) {
        return PacketSetGlobalVariable.forInt(varName, value ? 1 : 0);
    }

    public static PacketSetGlobalVariable fromNetwork(FriendlyByteBuf buf) {
        String varName = buf.readUtf(64);
        if (buf.readBoolean()) {
            return new PacketSetGlobalVariable(varName, (Either<BlockPos, ItemStack>)Either.left((Object)((BlockPos)buf.readNullable(FriendlyByteBuf::readBlockPos))));
        }
        return new PacketSetGlobalVariable(varName, (Either<BlockPos, ItemStack>)Either.right((Object)buf.readItem()));
    }

    public void write(FriendlyByteBuf buf) {
        this.value.ifLeft(pos -> {
            buf.writeBoolean(true);
            buf.writeNullable(pos, FriendlyByteBuf::writeBlockPos);
        }).ifRight(stack -> {
            buf.writeBoolean(false);
            buf.writeItem(stack);
        });
        buf.writeUtf(this.varName);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSetGlobalVariable message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            message.value().ifLeft(pos -> GlobalVariableHelper.setPos(player.getUUID(), message.varName(), pos)).ifRight(stack -> GlobalVariableHelper.setStack(player.getUUID(), message.varName(), stack));
            if (ctx.flow().isClientbound()) {
                RemoteScreen.maybeHandleVariableChange(message.varName());
                AreaRenderManager.getInstance().clearPosProviderCache();
            }
        }));
    }
}

