/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.IShiftScrollable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketShiftScrollWheel(boolean forward, InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("shift_scroll_wheel");

    public static PacketShiftScrollWheel fromNetwork(FriendlyByteBuf buf) {
        return new PacketShiftScrollWheel(buf.readBoolean(), (InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.forward);
        buf.writeEnum((Enum)this.hand);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketShiftScrollWheel message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            ItemStack stack = player.getItemInHand(message.hand());
            Item patt2298$temp = stack.getItem();
            if (patt2298$temp instanceof IShiftScrollable) {
                IShiftScrollable ss = (IShiftScrollable)patt2298$temp;
                ss.onShiftScrolled((Player)player, message.forward(), message.hand());
            }
        }));
    }
}

