/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Arrays;
import java.util.Set;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketShowArea(BlockPos pos, BlockPos[] area) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("show_area");

    public static PacketShowArea forPos(BlockPos pos) {
        return new PacketShowArea(pos, new BlockPos[0]);
    }

    public static PacketShowArea forArea(BlockPos pos, Set<BlockPos> area) {
        return new PacketShowArea(pos, area.toArray(new BlockPos[0]));
    }

    public static PacketShowArea fromNetwork(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        BlockPos[] area = new BlockPos[buffer.readInt()];
        for (int i = 0; i < area.length; ++i) {
            area[i] = buffer.readBlockPos();
        }
        return new PacketShowArea(pos, area);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeInt(this.area.length);
        Arrays.stream(this.area).forEach(arg_0 -> ((FriendlyByteBuf)buffer).writeBlockPos(arg_0));
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketShowArea message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> AreaRenderManager.getInstance().showArea(message.area(), -1878982657, ClientUtils.getBlockEntity(message.pos())));
    }
}

