/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.drone.DroneEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketShowWireframe(BlockPos pos, int entityId) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("show_wireframe");

    public static PacketShowWireframe create(DroneEntity entity, BlockPos pos) {
        return new PacketShowWireframe(pos, entity.getId());
    }

    public static PacketShowWireframe fromNetwork(FriendlyByteBuf buffer) {
        return new PacketShowWireframe(buffer.readBlockPos(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeInt(this.entityId);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketShowWireframe message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Entity patt2273$temp = ClientUtils.getClientLevel().getEntity(message.entityId());
            if (patt2273$temp instanceof DroneEntity) {
                DroneEntity drone = (DroneEntity)patt2273$temp;
                ClientUtils.addDroneToHudHandler(drone, message.pos());
            }
        });
    }
}

