/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketSpawnParticle(ParticleOptions particle, float x, float y, float z, float dx, float dy, float dz, int numParticles, float rx, float ry, float rz) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("spawn_particle");

    public PacketSpawnParticle(ParticleOptions particle, double x, double y, double z, double dx, double dy, double dz, int numParticles, double rx, double ry, double rz) {
        this(particle, (float)x, (float)y, (float)z, (float)dx, (float)dy, (float)dz, numParticles, (float)rx, (float)ry, (float)rz);
    }

    public PacketSpawnParticle(ParticleOptions particle, double x, double y, double z, double dx, double dy, double dz) {
        this(particle, (float)x, (float)y, (float)z, (float)dx, (float)dy, (float)dz, 1, 0.0f, 0.0f, 0.0f);
    }

    public static PacketSpawnParticle fromNetwork(FriendlyByteBuf buffer) {
        float rz;
        float ry;
        float rx;
        ParticleType type = (ParticleType)buffer.readById((IdMap)BuiltInRegistries.PARTICLE_TYPE);
        assert (type != null);
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        float z = buffer.readFloat();
        float dx = buffer.readFloat();
        float dy = buffer.readFloat();
        float dz = buffer.readFloat();
        int numParticles = buffer.readVarInt();
        if (numParticles > 1) {
            rx = buffer.readFloat();
            ry = buffer.readFloat();
            rz = buffer.readFloat();
        } else {
            rz = 0.0f;
            ry = 0.0f;
            rx = 0.0f;
        }
        Object particle = PacketSpawnParticle.readParticle(type, buffer);
        return new PacketSpawnParticle((ParticleOptions)particle, x, y, z, dx, dy, dz, numParticles, rx, ry, rz);
    }

    private static <T extends ParticleOptions> T readParticle(ParticleType<T> type, FriendlyByteBuf buffer) {
        return (T)type.getDeserializer().fromNetwork(type, buffer);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeId((IdMap)BuiltInRegistries.PARTICLE_TYPE, (Object)this.particle.getType());
        buffer.writeFloat(this.x);
        buffer.writeFloat(this.y);
        buffer.writeFloat(this.z);
        buffer.writeFloat(this.dx);
        buffer.writeFloat(this.dy);
        buffer.writeFloat(this.dz);
        buffer.writeVarInt(this.numParticles);
        if (this.numParticles > 1) {
            buffer.writeFloat(this.rx);
            buffer.writeFloat(this.ry);
            buffer.writeFloat(this.rz);
        }
        this.particle.writeToNetwork(new FriendlyByteBuf((ByteBuf)buffer));
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSpawnParticle message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Level world = ClientUtils.getClientLevel();
            int numParticles = message.numParticles();
            for (int i = 0; i < numParticles; ++i) {
                double x1 = (double)message.x() + (numParticles == 1 ? 0.0 : world.random.nextDouble() * (double)message.rx());
                double y1 = (double)message.y() + (numParticles == 1 ? 0.0 : world.random.nextDouble() * (double)message.ry());
                double z1 = (double)message.z() + (numParticles == 1 ? 0.0 : world.random.nextDouble() * (double)message.rz());
                world.addParticle(message.particle(), x1, y1, z1, (double)message.dx(), (double)message.dy(), (double)message.dz());
            }
        });
    }
}

