/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketSpawnParticleTrail(ParticleOptions particle, float x, float y, float z, float x2, float y2, float z2) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("particle_trail");

    public PacketSpawnParticleTrail(ParticleOptions particle, double x, double y, double z, double x2, double y2, double z2) {
        this(particle, (float)x, (float)y, (float)z, (float)x2, (float)y2, (float)z2);
    }

    public static PacketSpawnParticleTrail fromNetwork(FriendlyByteBuf buffer) {
        ParticleType type = (ParticleType)buffer.readById((IdMap)BuiltInRegistries.PARTICLE_TYPE);
        assert (type != null);
        float x = buffer.readFloat();
        float y = buffer.readFloat();
        float z = buffer.readFloat();
        float x2 = buffer.readFloat();
        float y2 = buffer.readFloat();
        float z2 = buffer.readFloat();
        Object particle = PacketSpawnParticleTrail.readParticle(type, buffer);
        return new PacketSpawnParticleTrail((ParticleOptions)particle, x, y, z, x2, y2, z2);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeId((IdMap)BuiltInRegistries.PARTICLE_TYPE, (Object)this.particle.getType());
        buffer.writeFloat(this.x);
        buffer.writeFloat(this.y);
        buffer.writeFloat(this.z);
        buffer.writeFloat(this.x2);
        buffer.writeFloat(this.y2);
        buffer.writeFloat(this.z2);
        this.particle.writeToNetwork(new FriendlyByteBuf((ByteBuf)buffer));
    }

    private static <T extends ParticleOptions> T readParticle(ParticleType<T> type, FriendlyByteBuf buffer) {
        return (T)type.getDeserializer().fromNetwork(type, buffer);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSpawnParticleTrail message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Level world = ClientUtils.getClientLevel();
            int numParticles = (int)PneumaticCraftUtils.distBetween(message.x(), message.y(), message.z(), message.x2(), message.y2(), message.z2()) * 25;
            if (numParticles == 0) {
                numParticles = 1;
            }
            for (int i = 0; i <= numParticles; ++i) {
                double pct = (double)i / (double)numParticles;
                double px = Mth.lerp((double)pct, (double)message.x(), (double)message.x2());
                double py = Mth.lerp((double)pct, (double)message.y(), (double)message.y2());
                double pz = Mth.lerp((double)pct, (double)message.z(), (double)message.z2());
                world.addParticle(message.particle(), px + world.random.nextDouble() * 0.2 - 0.1, py + world.random.nextDouble() * 0.2 - 0.1, pz + world.random.nextDouble() * 0.2 - 0.1, 0.0, 0.0, 0.0);
            }
        });
    }
}

