/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.Objects;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.entity.RingEntity;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.joml.Vector3f;

public record PacketSpawnRing(Vector3f vec, int targetEntityId, int color) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("spawn_ring");

    public static PacketSpawnRing create(BlockPos pos, Entity targetEntity, Integer color) {
        return new PacketSpawnRing(Vec3.atCenterOf((Vec3i)pos).toVector3f(), targetEntity.getId(), Objects.requireNonNullElse(color, -1));
    }

    public static PacketSpawnRing fromNetwork(FriendlyByteBuf buffer) {
        return new PacketSpawnRing(PacketUtil.readVec3f(buffer), buffer.readInt(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buffer) {
        PacketUtil.writeVec3f(this.vec, buffer);
        buffer.writeInt(this.targetEntityId);
        buffer.writeInt(this.color);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSpawnRing message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Level level = ClientUtils.getClientLevel();
            Entity entity = level.getEntity(message.targetEntityId());
            if (entity != null) {
                Vector3f vec = message.vec();
                ClientUtils.spawnEntityClientside(new RingEntity(level, vec.x, vec.y, vec.z, entity, message.color()));
            }
        });
    }
}

