/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.amadron.AmadronOfferManager;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.recipes.amadron.AmadronOffer;
import me.desht.pneumaticcraft.common.recipes.amadron.OfferType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketSyncAmadronOffers(Collection<AmadronOffer> activeOffers, boolean notifyPlayer) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("sync_amadron_offers");

    public static PacketSyncAmadronOffers createRequest() {
        return new PacketSyncAmadronOffers(List.of(), false);
    }

    public static PacketSyncAmadronOffers create(boolean notifyPlayer) {
        return new PacketSyncAmadronOffers(AmadronOfferManager.getInstance().getActiveOffers(), notifyPlayer);
    }

    public static PacketSyncAmadronOffers fromNetwork(FriendlyByteBuf buf) {
        boolean notifyPlayer = buf.readBoolean();
        ArrayList<AmadronOffer> activeOffers = new ArrayList<AmadronOffer>();
        int offerCount = buf.readVarInt();
        for (int i = 0; i < offerCount; ++i) {
            OfferType type = (OfferType)buf.readEnum(OfferType.class);
            type.read(buf).ifPresent(activeOffers::add);
        }
        return new PacketSyncAmadronOffers(activeOffers, notifyPlayer);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.notifyPlayer);
        buf.writeVarInt(this.activeOffers.size());
        for (AmadronOffer offer : this.activeOffers) {
            buf.writeEnum((Enum)offer.getOfferType());
            offer.getOfferType().write(buf, offer);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSyncAmadronOffers message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            if (ctx.flow().isClientbound()) {
                AmadronOfferManager.getInstance().syncOffers(message.activeOffers(), message.notifyPlayer());
            } else {
                ctx.player().ifPresent(player -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer sp = (ServerPlayer)player;
                        NetworkHandler.sendNonLocal(sp, PacketSyncAmadronOffers.create(false));
                    }
                });
            }
        });
    }
}

