/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.EnumSet;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.item.ClassifyFilterItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketSyncClassifyFilter(boolean matchAll, EnumSet<ClassifyFilterItem.FilterCondition> conditions, InteractionHand hand) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("sync_classify_filter");

    public static PacketSyncClassifyFilter fromNetwork(FriendlyByteBuf buf) {
        return new PacketSyncClassifyFilter(buf.readBoolean(), buf.readEnumSet(ClassifyFilterItem.FilterCondition.class), (InteractionHand)buf.readEnum(InteractionHand.class));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.matchAll);
        buf.writeEnumSet(this.conditions, ClassifyFilterItem.FilterCondition.class);
        buf.writeEnum((Enum)this.hand);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSyncClassifyFilter message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            ItemStack stack = player.getItemInHand(message.hand());
            if (stack.getItem() instanceof ClassifyFilterItem) {
                new ClassifyFilterItem.FilterSettings(message.matchAll(), message.conditions()).save(stack);
            }
        }));
    }
}

