/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.DroneDebugClientHandler;
import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.WidgetSerializer;
import me.desht.pneumaticcraft.common.network.DronePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PacketSyncDroneProgWidgets(DronePacket.DroneTarget droneTarget, List<IProgWidget> progWidgets) implements DronePacket
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("sync_drone_prog_widgets");

    public static PacketSyncDroneProgWidgets create(IDroneBase drone) {
        return new PacketSyncDroneProgWidgets(drone.getPacketTarget(), drone.getActiveAIManager().widgets());
    }

    public static PacketSyncDroneProgWidgets fromNetwork(FriendlyByteBuf buf) {
        return new PacketSyncDroneProgWidgets(DronePacket.DroneTarget.fromNetwork(buf), WidgetSerializer.readWidgetsFromPacket(buf));
    }

    public void write(FriendlyByteBuf buf) {
        this.droneTarget.toNetwork(buf);
        WidgetSerializer.writeProgWidgetsToPacket(this.progWidgets, buf);
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(Player player, IDroneBase droneBase) {
        List<IProgWidget> widgets = droneBase.getProgWidgets();
        widgets.clear();
        widgets.addAll(this.progWidgets);
        DroneDebugClientHandler.onWidgetsChanged();
    }
}

