/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.hacking.HackManager;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketSyncEntityHacks(int entityId, List<ResourceLocation> hackIds) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("sync_entity_hacks");

    public static PacketSyncEntityHacks create(Entity target, List<ResourceLocation> ids) {
        return new PacketSyncEntityHacks(target.getId(), ids);
    }

    public static PacketSyncEntityHacks fromNetwork(FriendlyByteBuf buf) {
        return new PacketSyncEntityHacks(buf.readInt(), buf.readList(FriendlyByteBuf::readResourceLocation));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeCollection(this.hackIds, FriendlyByteBuf::writeResourceLocation);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSyncEntityHacks message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            Entity e = ClientUtils.getClientLevel().getEntity(message.entityId());
            if (e != null) {
                HackManager.getActiveHacks(e).ifPresent(hacking -> {
                    for (ResourceLocation id : message.hackIds()) {
                        CommonArmorRegistry.getInstance().getHackableEntityForId(id).ifPresent(hacking::addHackable);
                    }
                });
            }
        });
    }
}

