/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.ArrayList;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.utility.SecurityStationBlockEntity;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.apache.commons.lang3.tuple.Pair;

public record PacketSyncHackSimulationUpdate(BlockPos pos, List<HackSimulation.ConnectionEntry> playerConns, List<HackSimulation.ConnectionEntry> aiConns, List<Pair<Integer, Integer>> fortification, boolean aiAwake, boolean aiStopWormed, boolean aiWon, boolean playerWon) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("sync_hack_simulation");

    public static PacketSyncHackSimulationUpdate forSecurityStation(SecurityStationBlockEntity te) {
        HackSimulation aiSim = te.getSimulationController().getSimulation(ISimulationController.HackingSide.AI);
        HackSimulation playerSim = te.getSimulationController().getSimulation(ISimulationController.HackingSide.PLAYER);
        List<HackSimulation.ConnectionEntry> playerConns = te.getSimulationController().getSimulation((ISimulationController.HackingSide)ISimulationController.HackingSide.PLAYER).allConnections;
        List<HackSimulation.ConnectionEntry> aiConns = aiSim.allConnections;
        ArrayList<Pair<Integer, Integer>> fortification = new ArrayList<Pair<Integer, Integer>>();
        for (int i = 0; i < 35; ++i) {
            if (aiSim.getNodeAt(i) == null || aiSim.getNodeAt(i).getFortification() <= 0) continue;
            fortification.add((Pair<Integer, Integer>)Pair.of((Object)i, (Object)aiSim.getNodeAt(i).getFortification()));
        }
        return new PacketSyncHackSimulationUpdate(te.getBlockPos(), playerConns, aiConns, fortification, aiSim.isAwake(), aiSim.isStopWormed(), aiSim.isHackComplete(), playerSim.isHackComplete());
    }

    public static PacketSyncHackSimulationUpdate fromNetwork(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        List playerConns = buffer.readList(HackSimulation.ConnectionEntry::readFromNetwork);
        List aiConns = buffer.readList(HackSimulation.ConnectionEntry::readFromNetwork);
        List fortification = buffer.readList(buf -> Pair.of((Object)buf.readVarInt(), (Object)buf.readVarInt()));
        boolean aiAwake = buffer.readBoolean();
        boolean aiStopWormed = buffer.readBoolean();
        boolean aiWon = buffer.readBoolean();
        boolean playerWon = buffer.readBoolean();
        return new PacketSyncHackSimulationUpdate(pos, playerConns, aiConns, fortification, aiAwake, aiStopWormed, aiWon, playerWon);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        buffer.writeCollection(this.playerConns, (buf, connectionEntry) -> connectionEntry.write((FriendlyByteBuf)buf));
        buffer.writeCollection(this.aiConns, (buf, connectionEntry) -> connectionEntry.write((FriendlyByteBuf)buf));
        buffer.writeCollection(this.fortification, (buf, pair) -> {
            buf.writeVarInt(((Integer)pair.getLeft()).intValue());
            buf.writeVarInt(((Integer)pair.getRight()).intValue());
        });
        buffer.writeBoolean(this.aiAwake);
        buffer.writeBoolean(this.aiStopWormed);
        buffer.writeBoolean(this.aiWon);
        buffer.writeBoolean(this.playerWon);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSyncHackSimulationUpdate message, PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            SecurityStationBlockEntity secStation;
            ISimulationController controller;
            BlockEntity te = ClientUtils.getBlockEntity(message.pos());
            if (te instanceof SecurityStationBlockEntity && (controller = (secStation = (SecurityStationBlockEntity)te).getSimulationController()) != null) {
                HackSimulation aiSim = controller.getSimulation(ISimulationController.HackingSide.AI);
                HackSimulation playerSim = controller.getSimulation(ISimulationController.HackingSide.PLAYER);
                playerSim.syncFromServer(message.playerConns());
                aiSim.syncFromServer(message.aiConns());
                aiSim.updateFortification(message.fortification());
                if (message.aiAwake()) {
                    aiSim.wakeUp();
                }
                aiSim.applyStopWorm(message.aiStopWormed() ? 100 : 0);
                if (message.aiWon()) {
                    aiSim.setHackComplete();
                }
                if (message.playerWon()) {
                    playerSim.setHackComplete();
                }
            }
        });
    }
}

