/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.TubeModulePacket;
import me.desht.pneumaticcraft.common.tubemodules.RedstoneModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PacketSyncRedstoneModuleToServer(TubeModulePacket.ModuleLocator locator, RedstoneModule.Operation op, byte ourColor, byte otherColor, int constantVal, boolean invert, RedstoneModule.EnumRedstoneDirection redstoneDirection, boolean comparatorInput) implements TubeModulePacket<RedstoneModule>
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("sync_redstone_module_to_server");

    public static PacketSyncRedstoneModuleToServer create(RedstoneModule module) {
        return new PacketSyncRedstoneModuleToServer(TubeModulePacket.ModuleLocator.forModule(module), module.getOperation(), (byte)module.getColorChannel(), (byte)module.getOtherColor(), module.getConstantVal(), module.isInverted(), module.getRedstoneDirection(), module.isComparatorInput());
    }

    public static PacketSyncRedstoneModuleToServer fromNetwork(FriendlyByteBuf buffer) {
        TubeModulePacket.ModuleLocator loc = TubeModulePacket.ModuleLocator.fromNetwork(buffer);
        RedstoneModule.EnumRedstoneDirection redstoneDir = (RedstoneModule.EnumRedstoneDirection)buffer.readEnum(RedstoneModule.EnumRedstoneDirection.class);
        byte ourColor = buffer.readByte();
        if (redstoneDir.isInput()) {
            return new PacketSyncRedstoneModuleToServer(loc, RedstoneModule.Operation.PASSTHROUGH, ourColor, 0, 0, false, RedstoneModule.EnumRedstoneDirection.INPUT, buffer.readBoolean());
        }
        return new PacketSyncRedstoneModuleToServer(loc, (RedstoneModule.Operation)buffer.readEnum(RedstoneModule.Operation.class), ourColor, buffer.readByte(), buffer.readVarInt(), buffer.readBoolean(), RedstoneModule.EnumRedstoneDirection.OUTPUT, false);
    }

    public void write(FriendlyByteBuf buf) {
        this.locator.write(buf);
        buf.writeEnum((Enum)this.redstoneDirection);
        buf.writeByte(this.ourColor);
        if (this.redstoneDirection.isInput()) {
            buf.writeBoolean(this.comparatorInput);
        } else {
            buf.writeEnum((Enum)this.op);
            buf.writeByte(this.otherColor);
            buf.writeVarInt(this.constantVal);
            buf.writeBoolean(this.invert);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void onModuleUpdate(RedstoneModule module, Player player) {
        if (PneumaticCraftUtils.canPlayerReach(player, module.getTube().getBlockPos())) {
            module.setRedstoneDirection(this.redstoneDirection);
            module.setColorChannel(this.ourColor);
            if (this.redstoneDirection.isInput()) {
                module.setComparatorInput(this.comparatorInput);
            } else {
                module.setInverted(this.invert);
                module.setOperation(this.op, this.otherColor, this.constantVal);
            }
            module.updateNeighbors();
            module.updateInputLevel();
        }
    }
}

