/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.semiblock.ISyncableSemiblockItem;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.apache.commons.lang3.Validate;

public record PacketSyncSemiblock(int entityID, FriendlyByteBuf payload) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("sync_semiblock");

    public static PacketSyncSemiblock create(ISemiBlock semiBlock, boolean itemContainer) {
        FriendlyByteBuf payload = (FriendlyByteBuf)Util.make((Object)new FriendlyByteBuf(Unpooled.buffer()), semiBlock::writeToBuf);
        return new PacketSyncSemiblock(itemContainer ? -1 : semiBlock.getTrackingId(), payload);
    }

    public static PacketSyncSemiblock fromNetwork(FriendlyByteBuf buffer) {
        int entityID = buffer.readInt();
        int size = buffer.readVarInt();
        FriendlyByteBuf payload = new FriendlyByteBuf(Unpooled.buffer((int)size));
        buffer.readBytes((ByteBuf)payload, size);
        return new PacketSyncSemiblock(entityID, payload);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeInt(this.entityID);
        int size = this.payload.writerIndex();
        buffer.writeVarInt(size);
        buffer.writeBytes((ByteBuf)this.payload, 0, size);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSyncSemiblock message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            if (ctx.flow().isClientbound()) {
                message.handleClient();
            } else if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                message.handleServer(sp);
            }
        }));
    }

    private void handleServer(ServerPlayer sender) {
        if (this.entityID == -1) {
            AbstractContainerMenu abstractContainerMenu = sender.containerMenu;
            if (abstractContainerMenu instanceof ISyncableSemiblockItem) {
                ISyncableSemiblockItem syncable = (ISyncableSemiblockItem)abstractContainerMenu;
                syncable.syncSemiblockItemFromClient((Player)sender, this.payload);
            } else {
                Log.warning("PacketSyncSemiblock: received packet with entity -1, but player is not holding a semiblock item?", new Object[0]);
            }
        } else {
            this.processEntity(sender.level());
        }
    }

    private void handleClient() {
        Validate.isTrue((this.entityID >= 0 ? 1 : 0) != 0);
        this.processEntity(ClientUtils.getClientLevel());
    }

    private void processEntity(Level world) {
        ISemiBlock semiBlock = ISemiBlock.byTrackingId(world, this.entityID);
        if (semiBlock != null) {
            semiBlock.readFromBuf(this.payload);
        } else {
            Log.warning("PacketSyncSemiblock: did not get expected ISemiBlock entity for entity ID {}", this.entityID);
        }
    }
}

