/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.block.entity.utility.SmartChestBlockEntity;
import me.desht.pneumaticcraft.common.network.PacketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.apache.commons.lang3.tuple.Pair;

public record PacketSyncSmartChest(BlockPos pos, int lastSlot, List<Pair<Integer, ItemStack>> filter) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("sync_smart_chest");

    public static PacketSyncSmartChest forBlockEntity(SmartChestBlockEntity te) {
        return new PacketSyncSmartChest(te.getBlockPos(), te.getLastSlot(), te.getFilter());
    }

    public static PacketSyncSmartChest fromNetwork(FriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        int lastSlot = buffer.readVarInt();
        List filter = buffer.readList(buf -> Pair.of((Object)buf.readVarInt(), (Object)buf.readItem()));
        return new PacketSyncSmartChest(pos, lastSlot, filter);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeVarInt(this.lastSlot);
        buf.writeCollection(this.filter, (b, pair) -> {
            b.writeVarInt(((Integer)pair.getLeft()).intValue());
            b.writeItem((ItemStack)pair.getRight());
        });
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketSyncSmartChest message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> PacketUtil.getBlockEntity(player, message.pos(), SmartChestBlockEntity.class).ifPresent(te -> {
            te.setLastSlot(message.lastSlot());
            te.setFilter(message.filter());
        })));
    }
}

