/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.common.network.TubeModulePacket;
import me.desht.pneumaticcraft.common.tubemodules.ThermostatModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PacketSyncThermostatModuleToServer(TubeModulePacket.ModuleLocator locator, byte channel, int threshold) implements TubeModulePacket<ThermostatModule>
{
    public static ResourceLocation ID = PneumaticRegistry.RL("sync_thermostat_module_to_server");

    public static PacketSyncThermostatModuleToServer create(ThermostatModule module) {
        return new PacketSyncThermostatModuleToServer(TubeModulePacket.ModuleLocator.forModule(module), (byte)module.getColorChannel(), module.getThreshold());
    }

    public static PacketSyncThermostatModuleToServer fromNetwork(FriendlyByteBuf buffer) {
        return new PacketSyncThermostatModuleToServer(TubeModulePacket.ModuleLocator.fromNetwork(buffer), buffer.readByte(), buffer.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        this.locator.write(buf);
        buf.writeByte(this.channel);
        buf.writeInt(this.threshold);
    }

    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void onModuleUpdate(ThermostatModule module, Player player) {
        if (PneumaticCraftUtils.canPlayerReach(player, module.getTube().getBlockPos())) {
            module.setColorChannel(this.channel);
            module.setThreshold(this.threshold);
            module.updateNeighbors();
            module.setUpdate(true);
        }
    }
}

