/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record PacketTeleportCommand(BlockPos pos) implements CustomPacketPayload
{
    public static final ResourceLocation ID = PneumaticRegistry.RL("teleport_command");

    public static PacketTeleportCommand fromNetwork(FriendlyByteBuf buf) {
        return new PacketTeleportCommand(buf.readBlockPos());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(PacketTeleportCommand message, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ctx.workHandler().submitAsync(() -> {
            CommandSourceStack stack = player.createCommandSourceStack();
            String command = String.format("tp %d %d %d", message.pos().getX(), message.pos().getY(), message.pos().getZ());
            player.getServer().getCommands().performPrefixedCommand(stack, command);
        }));
    }
}

